/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import com.gjhi.tinkersinnovation.register.TinkersInnovationToolStats;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.IToolStat;

public class StressModifier
extends NoLevelsModifier
implements InventoryTickModifierHook,
TooltipModifierHook {
    private final ResourceLocation STRESS_KEY = new ResourceLocation("tinkersinnovation", "stress");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.INVENTORY_TICK, ModifierHooks.TOOLTIP);
    }

    public void setStress(IToolStackView tool, float value) {
        tool.getPersistentData().putFloat(this.STRESS_KEY, Math.min(Math.max(value, 0.0f), ((Float)tool.getStats().get((IToolStat)TinkersInnovationToolStats.STRESS)).floatValue()));
    }

    public float getStress(IToolStackView tool) {
        return tool.getPersistentData().contains(this.STRESS_KEY, 5) ? tool.getPersistentData().getFloat(this.STRESS_KEY) : 0.0f;
    }

    public void addStress(IToolStackView tool, float value) {
        this.setStress(tool, this.getStress(tool) + value);
    }

    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        float speed = holder.m_6113_();
        if (speed > 5.0f && this.getStress(tool) < ((Float)tool.getStats().get((IToolStat)TinkersInnovationToolStats.STRESS)).floatValue()) {
            this.addStress(tool, 0.01f * speed);
        } else if (speed < 3.0f) {
            this.addStress(tool, -0.1f);
        }
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.tinkersinnovation.stress.amount", (Object[])new Object[]{Float.valueOf(this.getStress(tool)), tool.getStats().get((IToolStat)TinkersInnovationToolStats.STRESS)}));
    }
}

